/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.download.info;

import java.io.File;
import java.net.URL;
import java.util.List;

public class DownloadInfo {
    public URL url;
    public File local;
    public String name;
    public long size = 0L;
    public List<String> hash;
    public String hashType;
    private DLType primaryDLType = DLType.ETag;
    private DLType backupDLType = DLType.NONE;

    public DownloadInfo() {
    }

    public DownloadInfo(URL url, File local, String name, Boolean ftbServers) {
        this(url, local, name, null, "md5");
        if (ftbServers.booleanValue()) {
            this.primaryDLType = DLType.ContentMD5;
            this.backupDLType = DLType.FTBBackup;
        }
    }

    public DownloadInfo(URL url, File local, String name) {
        this(url, local, name, null, "md5");
    }

    public DownloadInfo(URL url, File local, String name, List<String> hash, String hashType, DLType primary, DLType backup) {
        this(url, local, name, hash, hashType);
        if (primary != null) {
            this.primaryDLType = primary;
        }
        if (backup != null) {
            this.backupDLType = backup;
        }
    }

    public DownloadInfo(URL url, File local, String name, List<String> hash, String hashType) {
        this.url = url;
        this.local = local;
        this.name = name;
        this.hash = hash;
        this.hashType = hashType;
    }

    public DLType getPrimaryDLType() {
        return this.primaryDLType;
    }

    public void setPrimaryDLType(DLType primaryDLType) {
        this.primaryDLType = primaryDLType;
    }

    public DLType getBackupDLType() {
        return this.backupDLType;
    }

    public void setBackupDLType(DLType backupDLType) {
        this.backupDLType = backupDLType;
    }

    public static enum DLType {
        ETag,
        ContentMD5,
        FTBBackup,
        NONE;

    }
}

